/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.BlockDataSource;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.EntityDataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.StorageDataSource;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringDecomposer;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.util.text.AdvancedStringSplitter;
import team.creative.creativecore.common.util.text.content.AdvancedContent;
import team.creative.creativecore.common.util.text.content.AdvancedContentConsumer;
import team.creative.creativecore.common.util.text.content.ContentItemStack;
import team.creative.creativecore.common.util.text.content.FormattedSingleSink;

public class AdvancedComponentHelper {
    public static final AdvancedStringSplitter SPLITTER = new AdvancedStringSplitter(Minecraft.m_91087_().f_91062_);
    private static final Optional<Object> STOP_ITERATION = Optional.of(Unit.INSTANCE);

    public static Component copy(Component component) {
        MutableComponent copy = MutableComponent.m_237204_((ComponentContents)component.m_214077_());
        for (Component sibling : component.m_7360_()) {
            copy.m_7360_().add(AdvancedComponentHelper.copy(sibling));
        }
        copy.m_6270_(component.m_7383_());
        return copy;
    }

    public static boolean iterateFormatted(Component text, Style style, final FormattedSingleSink sink) {
        return !AdvancedComponentHelper.visit(text, new AdvancedContentConsumer(){

            public Optional accept(Style style, AdvancedContent content) {
                return sink.accept(style, content) ? Optional.empty() : STOP_ITERATION;
            }

            public Optional m_7164_(Style style, String content) {
                return StringDecomposer.m_14311_((String)content.toString(), (int)0, (Style)style, (Style)style, (FormattedCharSink)sink) ? Optional.empty() : STOP_ITERATION;
            }
        }, style).isPresent();
    }

    public static <T> Optional<T> visit(Component text, AdvancedContentConsumer<T> consumer, Style defaultStyle) {
        Style style = text.m_7383_().m_131146_(defaultStyle);
        Optional<T> optional = AdvancedComponentHelper.visit(text.m_214077_(), consumer, style);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component component : text.m_7360_()) {
            Optional<T> optional1 = AdvancedComponentHelper.visit(component, consumer, style);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    public static <T> Optional<T> visit(ComponentContents content, AdvancedContentConsumer<T> consumer, Style style) {
        if (content instanceof AdvancedContent) {
            AdvancedContent adv = (AdvancedContent)content;
            return adv.visit(consumer, style);
        }
        return content.m_213724_((cStyle, text) -> consumer.m_7164_(cStyle, text), style);
    }

    public static class Serializer
    extends Component.Serializer {
        public JsonElement serialize(Component component, Type type, JsonSerializationContext context) {
            ComponentContents componentcontents;
            JsonObject jsonobject = new JsonObject();
            if (!component.m_7383_().m_131179_()) {
                this.serializeStyle(component.m_7383_(), jsonobject, context);
            }
            if (!component.m_7360_().isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (Component comp : component.m_7360_()) {
                    jsonarray.add(this.serialize(comp, (Type)((Object)Component.class), context));
                }
                jsonobject.add("extra", (JsonElement)jsonarray);
            }
            if ((componentcontents = component.m_214077_()) == ComponentContents.f_237124_) {
                jsonobject.addProperty("text", "");
            } else if (componentcontents instanceof ContentItemStack) {
                ContentItemStack stack = (ContentItemStack)componentcontents;
                jsonobject.addProperty("itemstack", stack.stack.m_41739_(new CompoundTag()).toString());
            } else if (componentcontents instanceof LiteralContents) {
                LiteralContents literalcontents = (LiteralContents)componentcontents;
                jsonobject.addProperty("text", literalcontents.f_237368_());
            } else if (componentcontents instanceof TranslatableContents) {
                TranslatableContents translatablecontents = (TranslatableContents)componentcontents;
                jsonobject.addProperty("translate", translatablecontents.m_237508_());
                if (translatablecontents.m_237523_().length > 0) {
                    JsonArray jsonarray1 = new JsonArray();
                    for (Object object : translatablecontents.m_237523_()) {
                        if (object instanceof Component) {
                            jsonarray1.add(this.serialize((Component)object, (Type)object.getClass(), context));
                            continue;
                        }
                        jsonarray1.add((JsonElement)new JsonPrimitive(String.valueOf(object)));
                    }
                    jsonobject.add("with", (JsonElement)jsonarray1);
                }
            } else if (componentcontents instanceof ScoreContents) {
                ScoreContents scorecontents = (ScoreContents)componentcontents;
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("name", scorecontents.m_237440_());
                jsonobject1.addProperty("objective", scorecontents.m_237453_());
                jsonobject.add("score", (JsonElement)jsonobject1);
            } else if (componentcontents instanceof SelectorContents) {
                SelectorContents selectorcontents = (SelectorContents)componentcontents;
                jsonobject.addProperty("selector", selectorcontents.m_237466_());
                this.serializeSeparator(context, jsonobject, selectorcontents.m_237479_());
            } else if (componentcontents instanceof KeybindContents) {
                KeybindContents keybindcontents = (KeybindContents)componentcontents;
                jsonobject.addProperty("keybind", keybindcontents.m_237348_());
            } else {
                if (!(componentcontents instanceof NbtContents)) {
                    throw new IllegalArgumentException("Don't know how to serialize " + componentcontents + " as a Component");
                }
                NbtContents nbtcontents = (NbtContents)componentcontents;
                jsonobject.addProperty("nbt", nbtcontents.m_237399_());
                jsonobject.addProperty("interpret", Boolean.valueOf(nbtcontents.m_237426_()));
                this.serializeSeparator(context, jsonobject, nbtcontents.m_237427_());
                DataSource datasource = nbtcontents.m_237428_();
                if (datasource instanceof BlockDataSource) {
                    BlockDataSource blockdatasource = (BlockDataSource)datasource;
                    jsonobject.addProperty("block", blockdatasource.f_237309_());
                } else if (datasource instanceof EntityDataSource) {
                    EntityDataSource entitydatasource = (EntityDataSource)datasource;
                    jsonobject.addProperty("entity", entitydatasource.f_237327_());
                } else {
                    if (!(datasource instanceof StorageDataSource)) {
                        throw new IllegalArgumentException("Don't know how to serialize " + componentcontents + " as a Component");
                    }
                    StorageDataSource storagedatasource = (StorageDataSource)datasource;
                    jsonobject.addProperty("storage", storagedatasource.f_237484_().toString());
                }
            }
            return jsonobject;
        }

        private static Object unwrapTextArgument(Object object) {
            ComponentContents componentcontents;
            Component component;
            if (object instanceof Component && (component = (Component)object).m_7383_().m_131179_() && component.m_7360_().isEmpty() && (componentcontents = component.m_214077_()) instanceof LiteralContents) {
                LiteralContents literalcontents = (LiteralContents)componentcontents;
                return literalcontents.f_237368_();
            }
            return object;
        }

        private Optional<Component> parseSeparator(Type type, JsonDeserializationContext context, JsonObject object) {
            return object.has("separator") ? Optional.of(this.deserialize(object.get("separator"), type, context)) : Optional.empty();
        }

        private void serializeSeparator(JsonSerializationContext context, JsonObject object, Optional<Component> optional) {
            optional.ifPresent(comp -> object.add("separator", this.serialize((Component)comp, (Type)comp.getClass(), context)));
        }

        private void serializeStyle(Style style, JsonObject object, JsonSerializationContext context) {
            JsonElement jsonelement = context.serialize((Object)style);
            if (jsonelement.isJsonObject()) {
                JsonObject jsonobject = (JsonObject)jsonelement;
                for (Map.Entry entry : jsonobject.entrySet()) {
                    object.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        public MutableComponent deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            MutableComponent mutablecomponent;
            if (element.isJsonPrimitive()) {
                return Component.m_237113_((String)element.getAsString());
            }
            if (!element.isJsonObject()) {
                if (element.isJsonArray()) {
                    JsonArray jsonarray1 = element.getAsJsonArray();
                    MutableComponent mutablecomponent1 = null;
                    for (JsonElement jsonelement : jsonarray1) {
                        MutableComponent mutablecomponent2 = this.deserialize(jsonelement, jsonelement.getClass(), context);
                        if (mutablecomponent1 == null) {
                            mutablecomponent1 = mutablecomponent2;
                            continue;
                        }
                        mutablecomponent1.m_7220_((Component)mutablecomponent2);
                    }
                    return mutablecomponent1;
                }
                throw new JsonParseException("Don't know how to turn " + element + " into a Component");
            }
            JsonObject jsonobject = element.getAsJsonObject();
            if (jsonobject.has("text")) {
                String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"text");
                mutablecomponent = s.isEmpty() ? Component.m_237119_() : Component.m_237113_((String)s);
            } else if (jsonobject.has("itemstack")) {
                try {
                    mutablecomponent = MutableComponent.m_237204_((ComponentContents)new ContentItemStack(ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)jsonobject.get("itemstack").getAsString()))));
                }
                catch (CommandSyntaxException e) {
                    throw new JsonParseException((Throwable)e);
                }
            } else if (jsonobject.has("translate")) {
                String s1 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"translate");
                if (jsonobject.has("with")) {
                    JsonArray jsonarray = GsonHelper.m_13933_((JsonObject)jsonobject, (String)"with");
                    Object[] aobject = new Object[jsonarray.size()];
                    for (int i = 0; i < aobject.length; ++i) {
                        aobject[i] = Serializer.unwrapTextArgument(this.deserialize(jsonarray.get(i), type, context));
                    }
                    mutablecomponent = Component.m_237110_((String)s1, (Object[])aobject);
                } else {
                    mutablecomponent = Component.m_237115_((String)s1);
                }
            } else if (jsonobject.has("score")) {
                JsonObject jsonobject1 = GsonHelper.m_13930_((JsonObject)jsonobject, (String)"score");
                if (!jsonobject1.has("name") || !jsonobject1.has("objective")) {
                    throw new JsonParseException("A score component needs a least a name and an objective");
                }
                mutablecomponent = Component.m_237099_((String)GsonHelper.m_13906_((JsonObject)jsonobject1, (String)"name"), (String)GsonHelper.m_13906_((JsonObject)jsonobject1, (String)"objective"));
            } else if (jsonobject.has("selector")) {
                Optional<Component> optional = this.parseSeparator(type, context, jsonobject);
                mutablecomponent = Component.m_237102_((String)GsonHelper.m_13906_((JsonObject)jsonobject, (String)"selector"), optional);
            } else if (jsonobject.has("keybind")) {
                mutablecomponent = Component.m_237117_((String)GsonHelper.m_13906_((JsonObject)jsonobject, (String)"keybind"));
            } else {
                BlockDataSource datasource;
                if (!jsonobject.has("nbt")) {
                    throw new JsonParseException("Don't know how to turn " + element + " into a Component");
                }
                String s2 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"nbt");
                Optional<Component> optional1 = this.parseSeparator(type, context, jsonobject);
                boolean flag = GsonHelper.m_13855_((JsonObject)jsonobject, (String)"interpret", (boolean)false);
                if (jsonobject.has("block")) {
                    datasource = new BlockDataSource(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"block"));
                } else if (jsonobject.has("entity")) {
                    datasource = new EntityDataSource(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"entity"));
                } else {
                    if (!jsonobject.has("storage")) {
                        throw new JsonParseException("Don't know how to turn " + element + " into a Component");
                    }
                    datasource = new StorageDataSource(new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"storage")));
                }
                mutablecomponent = Component.m_237105_((String)s2, (boolean)flag, optional1, (DataSource)datasource);
            }
            if (jsonobject.has("extra")) {
                JsonArray jsonarray2 = GsonHelper.m_13933_((JsonObject)jsonobject, (String)"extra");
                if (jsonarray2.size() <= 0) {
                    throw new JsonParseException("Unexpected empty array of components");
                }
                for (int j = 0; j < jsonarray2.size(); ++j) {
                    mutablecomponent.m_7220_((Component)this.deserialize(jsonarray2.get(j), type, context));
                }
            }
            mutablecomponent.m_6270_((Style)context.deserialize(element, Style.class));
            return mutablecomponent;
        }
    }
}

